/*
 * Decompiled with CFR 0.152.
 */
package space.essem.image2map;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import eu.pb4.mapcanvas.api.core.CanvasImage;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.gui.GuiInterface;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.imageio.ImageIO;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_9276;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import space.essem.image2map.CardboardWarning;
import space.essem.image2map.ImageData;
import space.essem.image2map.config.Image2MapConfig;
import space.essem.image2map.gui.PreviewGui;
import space.essem.image2map.renderer.MapRenderer;

public class Image2Map
implements ModInitializer {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static Image2MapConfig CONFIG = Image2MapConfig.loadOrCreateConfig();

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"image2map").requires(Permissions.require((String)"image2map.use", (int)Image2Map.CONFIG.minPermLevel))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"create").requires(Permissions.require((String)"image2map.create", (int)0))).then(class_2170.method_9244((String)"width", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new DitherModeSuggestionProvider(this)).then(class_2170.method_9244((String)"path", (ArgumentType)StringArgumentType.greedyString()).executes(this::createMap)))))).then(class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new DitherModeSuggestionProvider(this)).then(class_2170.method_9244((String)"path", (ArgumentType)StringArgumentType.greedyString()).executes(this::createMap))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"create-folder").requires(Permissions.require((String)"image2map.createfolder", (int)3).and(x -> Image2Map.CONFIG.allowLocalFiles))).then(class_2170.method_9244((String)"width", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"height", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new DitherModeSuggestionProvider(this)).then(class_2170.method_9244((String)"path", (ArgumentType)StringArgumentType.greedyString()).executes(this::createMapFromFolder)))))).then(class_2170.method_9244((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new DitherModeSuggestionProvider(this)).then(class_2170.method_9244((String)"path", (ArgumentType)StringArgumentType.greedyString()).executes(this::createMapFromFolder))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"preview").requires(Permissions.require((String)"image2map.preview", (int)0))).then(class_2170.method_9244((String)"path", (ArgumentType)StringArgumentType.greedyString()).executes(this::openPreview)))));
        ServerLifecycleEvents.SERVER_STARTED.register(s -> CardboardWarning.checkAndAnnounce());
    }

    private int openPreview(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        String input = StringArgumentType.getString(context, (String)"path");
        source.method_9226(() -> class_2561.method_43470((String)"Getting image..."), false);
        this.getImage(input).orTimeout(20L, TimeUnit.SECONDS).handleAsync((image, ex) -> {
            if (ex instanceof TimeoutException) {
                source.method_9226(() -> class_2561.method_43470((String)"Downloading or reading of the image took too long!"), false);
                return null;
            }
            if (ex != null) {
                RuntimeException ru;
                if (ex instanceof RuntimeException && (ru = (RuntimeException)ex).getCause() != null) {
                    ex = ru.getCause();
                }
                Throwable finalEx = ex;
                source.method_9226(() -> class_2561.method_43470((String)"The image isn't valid (hover for more info)!").method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)finalEx.getMessage())))), false);
                return null;
            }
            if (image == null) {
                source.method_9226(() -> class_2561.method_43470((String)"That doesn't seem to be a valid image (unknown reason)!"), false);
                return null;
            }
            GuiInterface patt0$temp = GuiHelpers.getCurrentGui((class_3222)source.method_44023());
            if (patt0$temp instanceof PreviewGui) {
                PreviewGui previewGui = (PreviewGui)patt0$temp;
                previewGui.close();
            }
            new PreviewGui(((class_2168)context.getSource()).method_44023(), (BufferedImage)image, input, DitherMode.NONE, image.getWidth(), image.getHeight());
            return null;
        }, (Executor)source.method_9211());
        return 1;
    }

    private CompletableFuture<BufferedImage> getImage(String input) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (!Image2Map.isValid(input)) {
                    if (!Image2Map.CONFIG.allowLocalFiles) return null;
                    Path path = FabricLoader.getInstance().getGameDir().resolve(input);
                    if (!Files.exists(path, new LinkOption[0])) return null;
                    return ImageIO.read(Files.newInputStream(path, new OpenOption[0]));
                }
                try (HttpClient client = HttpClient.newHttpClient();){
                    HttpRequest req = HttpRequest.newBuilder().GET().uri(URI.create(input)).timeout(Duration.ofSeconds(30L)).setHeader("User-Agent", "Image2Map mod").build();
                    HttpResponse<InputStream> stream = client.send(req, HttpResponse.BodyHandlers.ofInputStream());
                    BufferedImage bufferedImage = ImageIO.read(stream.body());
                    return bufferedImage;
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
    }

    private List<BufferedImage> getImageFromFolder(String input) {
        if (Image2Map.CONFIG.allowLocalFiles) {
            try {
                final ArrayList<BufferedImage> arr = new ArrayList<BufferedImage>();
                Path path = FabricLoader.getInstance().getGameDir().resolve(input);
                if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
                    Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            try {
                                BufferedImage x = ImageIO.read(Files.newInputStream(file, new OpenOption[0]));
                                if (x != null) {
                                    arr.add(x);
                                }
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                return arr;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return List.of();
    }

    private int createMap(CommandContext<class_2168> context) throws CommandSyntaxException {
        DitherMode mode;
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        String modeStr = StringArgumentType.getString(context, (String)"mode");
        try {
            mode = DitherMode.fromString(modeStr);
        }
        catch (IllegalArgumentException e) {
            throw new SimpleCommandExceptionType(() -> "Invalid dither mode '" + modeStr + "'").create();
        }
        String input = StringArgumentType.getString(context, (String)"path");
        source.method_9226(() -> class_2561.method_43470((String)"Getting image..."), false);
        this.getImage(input).orTimeout(20L, TimeUnit.SECONDS).handleAsync((arg_0, arg_1) -> Image2Map.lambda$createMap$18(source, context, mode, input, (class_1657)player, arg_0, arg_1), (Executor)source.method_9211());
        return 1;
    }

    private int createMapFromFolder(CommandContext<class_2168> context) throws CommandSyntaxException {
        DitherMode mode;
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        String modeStr = StringArgumentType.getString(context, (String)"mode");
        try {
            mode = DitherMode.fromString(modeStr);
        }
        catch (IllegalArgumentException e) {
            throw new SimpleCommandExceptionType(() -> "Invalid dither mode '" + modeStr + "'").create();
        }
        String input = StringArgumentType.getString(context, (String)"path");
        source.method_9226(() -> class_2561.method_43470((String)"Getting image..."), false);
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        for (BufferedImage image : this.getImageFromFolder(input)) {
            int height;
            int width;
            try {
                width = IntegerArgumentType.getInteger(context, (String)"width");
                height = IntegerArgumentType.getInteger(context, (String)"height");
            }
            catch (Throwable e) {
                width = image.getWidth();
                height = image.getHeight();
            }
            int finalHeight = height;
            int finalWidth = width;
            source.method_9226(() -> class_2561.method_43470((String)"Converting into maps..."), false);
            CanvasImage mapImage = MapRenderer.render(image, mode, finalWidth, finalHeight);
            List<class_1799> items = MapRenderer.toVanillaItems(mapImage, source.method_9225(), input);
            list.add(Image2Map.toSingleStack(items, input, width, height));
        }
        class_1799 bundle = new class_1799((class_1935)class_1802.field_27023);
        bundle.method_57379(class_9334.field_49650, (Object)new class_9276(list));
        player.method_7270(bundle);
        return 1;
    }

    public static void giveToPlayer(class_1657 player, List<class_1799> items, String input, int width, int height) {
        player.method_7270(Image2Map.toSingleStack(items, input, width, height));
    }

    public static class_1799 toSingleStack(List<class_1799> items, String input, int width, int height) {
        if (items.size() == 1) {
            return items.get(0);
        }
        class_1799 bundle = new class_1799((class_1935)class_1802.field_27023);
        bundle.method_57379(class_9334.field_49650, (Object)new class_9276(items));
        bundle.method_57379(class_9334.field_49628, (Object)((class_9279)class_9279.field_49302.method_57447((DynamicOps)class_2509.field_11560, ImageData.CODEC, (Object)ImageData.ofBundle(class_3532.method_15384((double)((double)width / 128.0)), class_3532.method_15384((double)((double)height / 128.0)))).getOrThrow()));
        bundle.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_43470((String)input))));
        bundle.method_57379(class_9334.field_50239, (Object)class_2561.method_43470((String)"Maps").method_27692(class_124.field_1065));
        return bundle;
    }

    public static boolean clickItemFrame(class_1657 player, class_1268 hand, class_1533 itemFrameEntity) {
        class_1799 stack = player.method_5998(hand);
        DataResult bundleData = ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57446(ImageData.CODEC);
        if (stack.method_31574(class_1802.field_27023) && bundleData.isSuccess() && ((ImageData)bundleData.getOrThrow()).quickPlace()) {
            int rot;
            class_2350 down;
            class_2350 right;
            class_1937 world = itemFrameEntity.method_37908();
            class_2338 start = itemFrameEntity.method_24515();
            int width = ((ImageData)bundleData.getOrThrow()).width();
            int height = ((ImageData)bundleData.getOrThrow()).height();
            class_1533[] frames = new class_1533[width * height];
            class_2350 facing = itemFrameEntity.method_5735();
            if (facing.method_10166() != class_2350.class_2351.field_11052) {
                right = facing.method_10160();
                down = class_2350.field_11033;
                rot = 0;
            } else {
                right = player.method_5735().method_10170();
                if (facing.method_10171() == class_2350.class_2352.field_11056) {
                    down = right.method_10170();
                    rot = player.method_5735().method_10153().method_10161();
                } else {
                    down = right.method_10160();
                    rot = (right.method_10166() == class_2350.class_2351.field_11051 ? player.method_5735() : player.method_5735().method_10153()).method_10161();
                }
            }
            class_2338.class_2339 mut = start.method_25503();
            for (int x2 = 0; x2 < width; ++x2) {
                for (int y = 0; y < height; ++y) {
                    mut.method_10101((class_2382)start);
                    mut.method_10104(right, x2);
                    mut.method_10104(down, y);
                    List entities = world.method_8390(class_1533.class, class_238.method_29968((class_243)class_243.method_24954((class_2382)mut)), entity1 -> entity1.method_5735() == facing && entity1.method_24515().equals((Object)mut));
                    if (entities.isEmpty()) continue;
                    frames[x2 + y * width] = (class_1533)entities.get(0);
                }
            }
            for (class_1799 map : ((class_9276)stack.method_58695(class_9334.field_49650, (Object)class_9276.field_49289)).method_57421()) {
                DataResult mapData = ((class_9279)map.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57446(ImageData.CODEC);
                if (!mapData.isSuccess() || !((ImageData)mapData.getOrThrow()).isReal()) continue;
                map = map.method_7972();
                ImageData newData = ((ImageData)mapData.getOrThrow()).withDirection(right, down, facing);
                map.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, x -> (class_9279)x.method_57447((DynamicOps)class_2509.field_11560, ImageData.CODEC, (Object)newData).getOrThrow());
                class_1533 frame = frames[((ImageData)mapData.getOrThrow()).x() + ((ImageData)mapData.getOrThrow()).y() * width];
                if (frame == null || !frame.method_6940().method_7960()) continue;
                frame.method_6935(map);
                frame.method_6939(rot);
                frame.method_5648(true);
            }
            stack.method_7934(1);
            return true;
        }
        return false;
    }

    public static boolean destroyItemFrame(class_1297 player, class_1533 itemFrameEntity) {
        class_1799 stack = itemFrameEntity.method_6940();
        DataResult tag = ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57446(ImageData.CODEC);
        if (stack.method_7909() == class_1802.field_8204 && tag.isSuccess() && ((ImageData)tag.getOrThrow()).right().isPresent() && ((ImageData)tag.getOrThrow()).down().isPresent() && ((ImageData)tag.getOrThrow()).facing().isPresent()) {
            int xo = ((ImageData)tag.getOrThrow()).x();
            int yo = ((ImageData)tag.getOrThrow()).y();
            int width = ((ImageData)tag.getOrThrow()).width();
            int height = ((ImageData)tag.getOrThrow()).height();
            class_2350 right = ((ImageData)tag.getOrThrow()).right().get();
            class_2350 down = ((ImageData)tag.getOrThrow()).down().get();
            class_2350 facing = ((ImageData)tag.getOrThrow()).facing().get();
            class_1937 world = itemFrameEntity.method_37908();
            class_2338 start = itemFrameEntity.method_24515();
            class_2338.class_2339 mut = start.method_25503();
            mut.method_10104(right, -xo);
            mut.method_10104(down, -yo);
            start = mut.method_10062();
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    mut.method_10101((class_2382)start);
                    mut.method_10104(right, x);
                    mut.method_10104(down, y);
                    List entities = world.method_8390(class_1533.class, class_238.method_29968((class_243)class_243.method_24954((class_2382)mut)), entity1 -> entity1.method_5735() == facing && entity1.method_24515().equals((Object)mut));
                    if (entities.isEmpty()) continue;
                    class_1533 frame = (class_1533)entities.get(0);
                    class_1799 frameStack = frame.method_6940();
                    tag = ((class_9279)frameStack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57446(ImageData.CODEC);
                    if (frameStack.method_7909() != class_1802.field_8204 || !tag.isSuccess() || !((ImageData)tag.getOrThrow()).right().isPresent() || !((ImageData)tag.getOrThrow()).down().isPresent() || !((ImageData)tag.getOrThrow()).facing().isPresent()) continue;
                    frame.method_6933(class_1799.field_8037, true);
                    frame.method_5648(false);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isValid(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static /* synthetic */ Object lambda$createMap$18(class_2168 source, CommandContext context, DitherMode mode, String input, class_1657 player, BufferedImage image, Throwable ex) {
        int height;
        int width;
        if (ex instanceof TimeoutException) {
            source.method_9226(() -> class_2561.method_43470((String)"Downloading or reading of the image took too long!"), false);
            return null;
        }
        if (ex != null) {
            RuntimeException ru;
            if (ex instanceof RuntimeException && (ru = (RuntimeException)ex).getCause() != null) {
                ex = ru.getCause();
            }
            Throwable finalEx = ex;
            source.method_9226(() -> class_2561.method_43470((String)"The image isn't valid (hover for more info)!").method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)finalEx.getMessage())))), false);
            return null;
        }
        if (image == null) {
            source.method_9226(() -> class_2561.method_43470((String)"That doesn't seem to be a valid image (unknown reason)!"), false);
            return null;
        }
        try {
            width = IntegerArgumentType.getInteger((CommandContext)context, (String)"width");
            height = IntegerArgumentType.getInteger((CommandContext)context, (String)"height");
        }
        catch (Throwable e) {
            width = image.getWidth();
            height = image.getHeight();
        }
        int finalHeight = height;
        int finalWidth = width;
        source.method_9226(() -> class_2561.method_43470((String)"Converting into maps..."), false);
        CompletableFuture.supplyAsync(() -> MapRenderer.render(image, mode, finalWidth, finalHeight)).thenAcceptAsync(mapImage -> {
            List<class_1799> items = MapRenderer.toVanillaItems(mapImage, source.method_9225(), input);
            Image2Map.giveToPlayer(player, items, input, finalWidth, finalHeight);
            source.method_9226(() -> class_2561.method_43470((String)"Done!"), false);
        }, (Executor)source.method_9211());
        return null;
    }

    public static enum DitherMode {
        NONE,
        FLOYD;


        public static DitherMode fromString(String string) {
            if (string.equalsIgnoreCase("NONE")) {
                return NONE;
            }
            if (string.equalsIgnoreCase("DITHER") || string.equalsIgnoreCase("FLOYD")) {
                return FLOYD;
            }
            throw new IllegalArgumentException("invalid dither mode");
        }
    }

    class DitherModeSuggestionProvider
    implements SuggestionProvider<class_2168> {
        DitherModeSuggestionProvider(Image2Map this$0) {
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
            builder.suggest("none");
            builder.suggest("dither");
            return builder.buildFuture();
        }
    }
}

