/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.fabric.common;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.config.enums.BreakMode;
import fr.rakambda.fallingtree.common.leaf.LeafBreakingHandler;
import fr.rakambda.fallingtree.common.network.ServerPacketHandler;
import fr.rakambda.fallingtree.common.utils.BoundedList;
import fr.rakambda.fallingtree.common.wrapper.DirectionCompat;
import fr.rakambda.fallingtree.common.wrapper.IBlock;
import fr.rakambda.fallingtree.common.wrapper.IBlockBreakEvent;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.IComponent;
import fr.rakambda.fallingtree.common.wrapper.IItem;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import fr.rakambda.fallingtree.common.wrapper.IWrapper;
import fr.rakambda.fallingtree.fabric.FallingTreeUtils;
import fr.rakambda.fallingtree.fabric.common.wrapper.BlockWrapper;
import fr.rakambda.fallingtree.fabric.common.wrapper.ComponentWrapper;
import fr.rakambda.fallingtree.fabric.common.wrapper.ItemStackWrapper;
import fr.rakambda.fallingtree.fabric.common.wrapper.ItemWrapper;
import fr.rakambda.fallingtree.fabric.event.BlockBreakListener;
import fr.rakambda.fallingtree.fabric.event.LeafBreakingListener;
import fr.rakambda.fallingtree.fabric.event.ServerCommandRegistrationListener;
import fr.rakambda.fallingtree.fabric.network.FabricServerPacketHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class FallingTreeCommonsImpl
extends FallingTreeCommon<class_2350> {
    private final LeafBreakingHandler leafBreakingHandler = new LeafBreakingHandler(this);
    private final ServerPacketHandler serverPacketHandler = new FabricServerPacketHandler(this);
    private final class_6862<class_1887> chopperEnchantmentTag;
    private final Map<BreakMode, class_6862<class_1887>> breakModeChopperEnchantmentTag;
    private final List<IBlockPos> breakEvents;
    private final Map<IBlock, Boolean> isLogBlockCache = new HashMap<IBlock, Boolean>();
    private final Map<IBlock, Boolean> isLeafBlockCache = new HashMap<IBlock, Boolean>();
    private final Map<IBlock, Boolean> isWartBlockCache = new HashMap<IBlock, Boolean>();

    public FallingTreeCommonsImpl() {
        this.chopperEnchantmentTag = class_6862.method_40092((class_5321)class_7924.field_41265, (class_2960)FallingTreeUtils.id("chopper_all"));
        this.breakModeChopperEnchantmentTag = new HashMap<BreakMode, class_6862<class_1887>>();
        this.breakModeChopperEnchantmentTag.put(BreakMode.FALL_ALL_BLOCK, (class_6862<class_1887>)class_6862.method_40092((class_5321)class_7924.field_41265, (class_2960)FallingTreeUtils.id("chopper_fall_all_block")));
        this.breakModeChopperEnchantmentTag.put(BreakMode.FALL_BLOCK, (class_6862<class_1887>)class_6862.method_40092((class_5321)class_7924.field_41265, (class_2960)FallingTreeUtils.id("chopper_fall_block")));
        this.breakModeChopperEnchantmentTag.put(BreakMode.FALL_ITEM, (class_6862<class_1887>)class_6862.method_40092((class_5321)class_7924.field_41265, (class_2960)FallingTreeUtils.id("chopper_fall_item")));
        this.breakModeChopperEnchantmentTag.put(BreakMode.INSTANTANEOUS, (class_6862<class_1887>)class_6862.method_40092((class_5321)class_7924.field_41265, (class_2960)FallingTreeUtils.id("chopper_instantaneous")));
        this.breakModeChopperEnchantmentTag.put(BreakMode.SHIFT_DOWN, (class_6862<class_1887>)class_6862.method_40092((class_5321)class_7924.field_41265, (class_2960)FallingTreeUtils.id("chopper_shift_down")));
        this.breakEvents = new BoundedList<IBlockPos>(50);
    }

    @Override
    @NotNull
    public IComponent translate(@NotNull String key, Object ... objects) {
        Object[] vars = Arrays.stream(objects).map(o -> {
            if (o instanceof IComponent) {
                IComponent component = (IComponent)o;
                return component.getRaw();
            }
            return o;
        }).toArray();
        return new ComponentWrapper(class_2561.method_43469((String)key, (Object[])vars));
    }

    @Override
    @NotNull
    public Stream<IBlock> getBlock(@NotNull String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            class_2960 identifier = FallingTreeUtils.idExternal(name);
            if (isTag) {
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)identifier);
                return this.getRegistryTagContent((class_2378)class_7923.field_41175, (class_6862)tag).map(BlockWrapper::new);
            }
            return this.getRegistryElement((class_2378)class_7923.field_41175, identifier).stream().map(BlockWrapper::new);
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    @Override
    @NotNull
    public Stream<IItem> getItem(@NotNull String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            class_2960 identifier = FallingTreeUtils.idExternal(name);
            if (isTag) {
                class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)identifier);
                return this.getRegistryTagContent((class_2378)class_7923.field_41178, (class_6862)tag).map(ItemWrapper::new);
            }
            return this.getRegistryElement((class_2378)class_7923.field_41178, identifier).stream().map(ItemWrapper::new);
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    @Override
    public boolean isLeafBlock(@NotNull IBlock block) {
        return this.isLeafBlockCache.computeIfAbsent(block, Key -> {
            boolean isAllowedBlock;
            boolean bl = isAllowedBlock = this.registryTagContains((class_2378)class_7923.field_41175, (class_6862)class_3481.field_15503, (Object)((class_2248)block.getRaw())) || this.getConfiguration().getTrees().getAllowedLeaveBlocks(this).stream().anyMatch(leaf -> leaf.equals(block));
            if (isAllowedBlock) {
                boolean isDeniedBlock = this.getConfiguration().getTrees().getDeniedLeaveBlocks(this).stream().anyMatch(leaf -> leaf.equals(block));
                return !isDeniedBlock;
            }
            return false;
        });
    }

    @Override
    public boolean isLogBlock(@NotNull IBlock block) {
        return this.isLogBlockCache.computeIfAbsent(block, Key -> {
            boolean isAllowedBlock;
            boolean bl = isAllowedBlock = this.getConfiguration().getTrees().getDefaultLogsBlocks(this).stream().anyMatch(log -> log.equals(block)) || this.getConfiguration().getTrees().getAllowedLogBlocks(this).stream().anyMatch(log -> log.equals(block));
            if (isAllowedBlock) {
                boolean isDeniedBlock = this.getConfiguration().getTrees().getDeniedLogBlocks(this).stream().anyMatch(log -> log.equals(block));
                return !isDeniedBlock;
            }
            return false;
        });
    }

    @Override
    @NotNull
    public Set<IBlock> getAllNonStrippedLogsBlocks() {
        return this.getRegistryTagContent((class_2378)class_7923.field_41175, (class_6862)class_3481.field_15475).filter(block -> Optional.of(class_7923.field_41175.method_10221(block)).map(class_2960::method_12832).map(name -> name.startsWith("stripped")).orElse(false) == false).map(BlockWrapper::new).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public DirectionCompat asDirectionCompat(@NotNull class_2350 dir) {
        return DirectionCompat.valueOf(dir.name());
    }

    @Override
    @NotNull
    public class_2350 asDirection(@NotNull DirectionCompat dir) {
        return class_2350.valueOf((String)dir.name());
    }

    @Override
    public boolean isNetherWartOrShroomlight(@NotNull IBlock block) {
        return this.isWartBlockCache.computeIfAbsent(block, Key -> this.registryTagContains((class_2378)class_7923.field_41175, (class_6862)class_3481.field_21954, (Object)((class_2248)block.getRaw())) || class_2246.field_22122.equals(block.getRaw()));
    }

    @Override
    public boolean isMangroveRoots(@NotNull IBlock block) {
        return class_2246.field_37546.equals(block.getRaw());
    }

    @Override
    public boolean checkCanBreakBlock(@NotNull ILevel level, @NotNull IBlockPos blockPos, @NotNull IBlockState blockState, @NotNull IPlayer player) {
        this.breakEvents.add(blockPos);
        return ((PlayerBlockBreakEvents.Before)PlayerBlockBreakEvents.BEFORE.invoker()).beforeBlockBreak((class_1937)level.getRaw(), (class_1657)player.getRaw(), (class_2338)blockPos.getRaw(), (class_2680)blockState.getRaw(), (class_2586)Optional.ofNullable(level.getBlockEntity(blockPos)).map(IWrapper::getRaw).orElse(null));
    }

    @Override
    public boolean isOwnEvent(@NotNull IBlockBreakEvent event) {
        boolean result = this.breakEvents.contains(event.getBlockPos());
        if (result) {
            this.breakEvents.remove(event.getBlockPos());
        }
        return result;
    }

    @Override
    @NotNull
    public IItemStack getEmptyItemStack() {
        return new ItemStackWrapper(class_1799.field_8037);
    }

    @Override
    public void onConfigUpdate() {
        this.isLogBlockCache.clear();
        this.isLeafBlockCache.clear();
        this.isWartBlockCache.clear();
    }

    @NotNull
    private <T> Optional<T> getRegistryElement(class_2378<T> registryKey, class_2960 identifier) {
        return registryKey.method_17966(identifier);
    }

    @NotNull
    private <T> Stream<T> getRegistryTagContent(@NotNull class_2378<T> registry, @NotNull class_6862<T> tag) {
        return registry.method_46733(tag).stream().flatMap(a -> a.method_40239().map(class_6880::comp_349));
    }

    private <T> boolean registryTagContains(@NotNull class_2378<T> registry, @NotNull class_6862<T> tag, @NotNull T element) {
        return this.getRegistryTagContent(registry, tag).anyMatch(element::equals);
    }

    public void register() {
        this.getServerPacketHandler().registerServer();
        ServerTickEvents.END_SERVER_TICK.register((Object)new LeafBreakingListener(this));
        ServerWorldEvents.UNLOAD.register((Object)new LeafBreakingListener(this));
        PlayerBlockBreakEvents.BEFORE.register((Object)new BlockBreakListener(this));
        PlayerBlockBreakEvents.AFTER.register((Object)new BlockBreakListener(this));
        CommandRegistrationCallback.EVENT.register((Object)new ServerCommandRegistrationListener(this));
    }

    @Override
    @Generated
    public LeafBreakingHandler getLeafBreakingHandler() {
        return this.leafBreakingHandler;
    }

    @Override
    @Generated
    public ServerPacketHandler getServerPacketHandler() {
        return this.serverPacketHandler;
    }

    @Generated
    public class_6862<class_1887> getChopperEnchantmentTag() {
        return this.chopperEnchantmentTag;
    }

    @Generated
    public Map<BreakMode, class_6862<class_1887>> getBreakModeChopperEnchantmentTag() {
        return this.breakModeChopperEnchantmentTag;
    }
}

